% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweetfunctions.R
\name{linear.kernel}
\alias{linear.kernel}
\alias{power.kernel}
\alias{integral.memory.kernel}
\title{Integration with respect to locally weighted kernel}
\usage{
linear.kernel(t1, t2, ptime, slope, c = 0.0006265725)

power.kernel(
  t1,
  t2,
  ptime,
  share.time,
  slope,
  theta = 0.2314843,
  cutoff = 300,
  c = 0.0006265725
)

integral.memory.kernel(
  p.time,
  share.time,
  slope,
  window,
  theta = 0.2314843,
  cutoff = 300,
  c = 0.0006265725
)
}
\arguments{
\item{t1}{a vector of integral lower limit}

\item{t2}{a vector of integral upper limit}

\item{ptime}{the time (a scalar) to estimate infectiousness and predict for popularity}

\item{slope}{slope of the linear kernel}

\item{c}{the constant density when t is less than the cutoff}

\item{share.time}{observed resharing times, sorted, share.time[1] =0}

\item{theta}{exponent of the power law}

\item{cutoff}{the cutoff value where the density changes from constant to power law}

\item{p.time}{equally spaced vector of time to estimate the infectiousness, p.time[1]=0}

\item{window}{size of the linear kernel}
}
\value{
\code{linear.kernel} returns the integral from vector t1 to vector t2 of
c*[slope(t-ptime) + 1];
\code{power.kernel} returns the integral from vector t1 to vector 2 of c*((t-share.time)/cutoff)^(-(1+theta))[slope(t-ptime) + 1];
\code{integral.memory.kernel} returns the vector with ith entry being integral_-inf^inf phi_share.time[i]*kernel(t-p.time)
}
\description{
Integration with respect to locally weighted kernel
}
\section{Functions}{
\itemize{
\item \code{power.kernel}: Power-law kernel

\item \code{integral.memory.kernel}: Integral of the kernel
}}

\seealso{
\code{\link{memory.pdf}}
}
\keyword{internal}
