% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweetfunctions.R
\name{memory.pdf}
\alias{memory.pdf}
\alias{memory.ccdf}
\title{Memory kernel}
\usage{
memory.pdf(t, theta = 0.2314843, cutoff = 300, c = 0.0006265725)

memory.ccdf(t, theta = 0.2314843, cutoff = 300, c = 0.0006265725)
}
\arguments{
\item{t}{time}

\item{theta}{exponent of the power law}

\item{cutoff}{the cutoff value where the density changes from constant to power law}

\item{c}{the constant density when t is less than the cutoff}
}
\value{
the density at t

\code{memory.pdf} returns the density function at t.
\code{memory.ccdf} returns the ccdf (probabilty of greater than t).
}
\description{
Probability density function and complementary cumulative distribution function
for the human reaction time.
}
\details{
default values are measured from a real Twitter data set.
}
\section{Functions}{
\itemize{
\item \code{memory.ccdf}: Complementary cumulative distribution function
}}

\keyword{internal}
