% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_database.R
\name{create_database}
\alias{create_database}
\title{Creating database}
\usage{
create_database(dbname, user, password, host)
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}
}
\value{
invisible NULL
}
\description{
Function \code{create_database} creates a database with four empty
tables: deputies, votings, votes, statements.
}
\details{
\preformatted{
Created tables:
1. deputies with columns:
    1) id_deputy - deputy's id,
    2) nr_term_of_office - Polish Diet's number of term of office,
    3) surname_name - deputy's names and surnames,
2. votings with columns:
    1) id_voting - voting's id,
    2) nr_term_of_office - Polish Diet's number of term of office,
    3) nr_meeting - meeting's number,
    4) date_meeting - meeting's date,
    5) nr_voting - voting's number,
    6) topic_voting - voting's topic,
    7) link_results - link with voting's results,
3. votes with columns:
    1) id_vote - vote's id,
    2) nr_term_of_office - Polish Diet's number of term of office,
    3) id_deputy - deputy's id,
    4) id_voting - voting's id,
    5) vote - deputy's vote, one of: 'Za','Przeciw',
              'Wstrzymal sie','Nieobecny',
    6) club - deputy's club,
4. statements with columns:
    1) id_statement - statement's id, like: 
    (meeting's number).(voting's number).(statement's number),
    2) nr_term_of_office - Polish Diet's number of term of office,
    3) surname_name - author of statement,
    4) date_statement - statement's date,
    5) titles_order_points - title of order points,
    6) statement - content of statement.}
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
create_database(dbname, user, password, host)}

}
\author{
Piotr Smuda
}

