% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/votings_get_votings_links.R
\name{votings_get_votings_links}
\alias{votings_get_votings_links}
\title{Getting votings' links}
\usage{
votings_get_votings_links(home_page = 'http://www.sejm.gov.pl/Sejm8.nsf/',
  page)
}
\arguments{
\item{home_page}{main page of polish diet: http://www.sejm.gov.pl/Sejm8.nsf/}

\item{page}{meeting's page}
}
\value{
character vector
}
\description{
Function \code{votings_get_votings_links} gets votings' links from
meeting's page.
}
\details{
Example of a meeting's page: 
http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?symbol=listaglos&IdDnia=1179
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
home_page <- 'http://www.sejm.gov.pl/Sejm7.nsf/'
page <- 'http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?symbol=listaglos&IdDnia=1179'
votings_get_votings_links(home_page, page)}

}
\author{
Piotr Smuda
}

