% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{as.list.selenider_elements}
\alias{as.list.selenider_elements}
\title{Iterate over an element collection}
\usage{
\method{as.list}{selenider_elements}(x, timeout = NULL, ...)
}
\arguments{
\item{x}{A \code{selenider_elements} object.}

\item{timeout}{How long to wait for \code{x} to exist while computing its length.}

\item{...}{Not used.}
}
\value{
A list of \code{selenider_element} objects.
}
\description{
This function essentially turns \code{x} into:
\code{list(x[[1]], x[[2]], ...)}
However, to do this, the length of \code{x} must be computed. This means that
while each element inside the list is still lazy, the list itself cannot be
considered lazy, since the number of elements in the DOM may change. To
avoid problems, it is recommended to use an element list just after it is
created, to make sure the list is an accurate representation of the DOM
when it is being used.
}
\details{
Transform a \code{selenider_elements} object into a list of
\code{selenider_element} objects. The result can then be used in for loops and
higher order functions like \code{\link[=lapply]{lapply()}}/\code{\link[purrr:map]{purrr::map()}} (whereas a
\code{selenider_element} object cannot).
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div id='div1'>
  <p>Text 1</p>
</div>
<div id='div2'>
  <p>Text 2</p>
</div>
<div id='div3'>
  <p>Text 3</p>
</div>
<div id='div4'>
  <p>Text 4</p>
</div>
"

session <- minimal_selenider_session(html)

p_tags <- ss("p")

for (elem in as.list(p_tags)) {
  print(elem_text(elem))
}

p_tags |>
  as.list() |>
  lapply(elem_text)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=elem_flatten]{elem_flatten()}} to combine multiple
\code{selenider_element}/\code{selenider_elements} objects into a single object.
\item \code{\link[=find_each_element]{find_each_element()}} and \code{\link[=find_all_elements]{find_all_elements()}} to select elements
using an element collection while preserving laziness.
}
}
