% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_actions.R
\name{scroll_to}
\alias{scroll_to}
\alias{scroll_by}
\title{Scroll along the page}
\usage{
scroll_to(top = 0, left = 0, session = NULL)

scroll_by(top = 0, left = 0, session = NULL)
}
\arguments{
\item{top}{The vertical scroll position/offset, in pixels.}

\item{left}{The horizontal scroll position/offset, in pixels.}

\item{session}{A \code{selenider_session} object. If not specified, the global
session object (the result of \code{\link[=get_session]{get_session()}}) is used.}
}
\description{
\code{scroll_to()} scrolls the page to the specified coordinates.

\code{scroll_by()} scrolls the page by the specified amount.
}
\examples{
\dontshow{if (selenider::selenider_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- selenider_session()

open_url("https://r-project.org")

scroll_to(100, 100)

# Scrolls an additional 100 pixels down
scroll_by(100)
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{back}()},
\code{\link{current_url}()},
\code{\link{execute_js_fn}()},
\code{\link{get_page_source}()},
\code{\link{open_url}()},
\code{\link{reload}()},
\code{\link{take_screenshot}()}
}
\concept{global actions}
