% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{genData}
\alias{genData}
\title{genData}
\usage{
genData(
  N = NULL,
  Sigma = NULL,
  mu = NULL,
  nSets = 1,
  gIdx = NULL,
  modelH0 = NULL,
  simOptions = NULL
)
}
\arguments{
\item{N}{sample size.}

\item{Sigma}{population covariance matrix.}

\item{mu}{population means.}

\item{nSets}{number of data sets to generate}

\item{gIdx}{if not \code{NULL}, add gIdx as numeric group index as additional variable to generated data}

\item{modelH0}{a \code{lavaan} model string, only used to determine the number of factors when \code{type = 'RK'}}

\item{simOptions}{additional arguments specifying the data generation routine}
}
\value{
Returns the generated data
}
\description{
Generates random data from population variance-covariance matrix and population means, either
from a multivariate normal distribution, or using one of various approaches to generate
non-normal data.
}
\examples{
\dontrun{
gen <- semPower.genSigma(Phi = .2, loadings = list(rep(.5, 3), rep(.7, 3)))
data <- genData(N = 500, Sigma = gen$Sigma) 
}
}
