% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv.R
\name{mv_sis}
\alias{mv_sis}
\title{Feature screening via MV Index}
\usage{
mv_sis(X, y, d = NULL, parallel = FALSE)
}
\arguments{
\item{X}{Data of multivariate covariates, which should be an
\eqn{n}-by-\eqn{p} matrix.}

\item{y}{Data of categorical response, which should be a factor of length
\eqn{n}.}

\item{d}{An integer specifying how many features should be kept after
screening. Defaults to \code{NULL}. If \code{NULL}, then it will be set as \eqn{[n /
  log(n)]}, where \eqn{[x]} denotes the integer part of x.}

\item{parallel}{A boolean indicating whether to calculate parallelly via
\code{furrr::future_map}. Defaults to \code{FALSE}.}
}
\value{
A list of the objects about the implemented feature screening:
\itemize{
\item \code{measurement}: sample MV index calculated for each single covariate;
\item \code{selected}: indicies or names (if avaiable as colnames of \code{X}) of
covariates that are selected after feature screening;
\item \code{ordering}: order of the calculated measurements of each single covariate.
The first one is the largest, and the last is the smallest.
}
}
\description{
Implement the feature screening for the classification problem
via MV index.
}
\examples{
X <- mtcars[, c("mpg", "disp", "hp", "drat", "wt", "qsec")]
y <- factor(mtcars[, "am"])

mv_sis(X, y, d = 4)

}
