% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStudiesSTSTDTC.R
\name{getStudiesSTSTDTC}
\alias{getStudiesSTSTDTC}
\title{Extract a list of SEND studies with study start date within a specified
interval - or just add actual study start date for each study}
\usage{
getStudiesSTSTDTC(
  dbToken,
  studyList = NULL,
  fromDTC = NULL,
  toDTC = NULL,
  inclUncertain = FALSE,
  noFilterReportUncertain = TRUE
)
}
\arguments{
\item{dbToken}{Mandatory.\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{studyList}{Optional.\cr
A data.table with the list of studies to process. If empty, all studies in
the data base are processed \cr
The table must include at least a column named 'STUDYID'.}

\item{fromDTC}{Optional (either or both of \code{fromDTC} and \code{toDTC}
must be filled).\cr
The start of the date interval to extract - must be in ISO8601 date format.}

\item{toDTC}{Optional (either or both of \code{fromDTC} and \code{toDTC} must be filled).\cr
The end of the date interval to extract - must be in ISO8601 date format.}

\item{inclUncertain}{Mandatory, boolean.\cr
Indicates whether study ids with STSTDTC which are are missing or wrong
shall be included or not in the output data table.}

\item{noFilterReportUncertain}{Mandatory, boolean\cr
Only relevant if the \code{fromDTC} and\code{toDTC} are empty.\cr
Indicates if the reason should be included if the STSTDTC cannot be
confidently decided for an animal.}
}
\value{
The function return a data.table with columns:
\itemize{
\item STUDYID       (character)
\item Additional columns contained in the \code{studyList} table (if such an input
table is given)
\item STSTDTC       (character - ISO8601 format)
\item UNCERTAIN_MSG (character)\cr
Only included when parameter \code{inclUncertain=TRUE}.\cr
Contains indication of whether STSTDTC is missing of has wrong
format.\cr
Is NA for rows where SDESIGN is valid.\cr
A non-empty UNCERTAIN_MSG value generated by this function is merged with
non-empty UNCERTAIN_MSG values which may exist in the optional input set of
studies specified in \code{studyList} - separated by '|'.
\item NOT_VALID_MSG (character)\cr
Included when parameter \code{noFilterReportUncertain=TRUE}.\cr
In case the STSTDTC cannot be confidently decided, the column contains an
indication of the reason.\cr
Is NA for rows where STSTDTC can be confidently decided.\cr
A non-empty NOT_VALID_MSG value generated by this function is merged with
non-empty NOT_VALID_MSG values which may exist in the input set of studies
specified in \code{studyList} - separated by '|'.
}
}
\description{
Returns a data table with the list of study ids from TS where the value of
TSVAL for the TSPARMCD 'STSTDTC' is within a a given date interval.\cr
If the \code{fromDTC} and\code{toDTC} are empty (null, na or empty string)
\itemize{
\item all rows for the TSPARMCD 'STSTDTC' are returned.
}
}
\details{
Extracts the set of study ids from TS where the value of TSVAL for the
TSPARMCD 'STSTDTC' falls within a specified start/end date interval in IS8601
format (input parameters \code{fromDTC}/\code{toDTC}).\cr

Both complete and incomplete input start/end dates can be handled.
\itemize{
\item If only a year is specified - the date set to the first of January that
year.
\item If only a year and month is specified - the date set to the first day
in that month.
\item If a time part is included in a specified input start/end date, it is
ignored.
}

If both a start and end input date are specified - all the STUDYID values
from TS where TSVAL for TSPARMCD 'STSTDTC' is with the interval of the
specified start/end date interval are extracted and returned - including the
values equal to the start/end dates. are included.\cr

If only a start input date is specified - all the STUDYID values from TS
where TSVAL for TSPARMCD 'STSTDTC' is equal to or later than the input date
are extracted and returned.\cr

If only an end date is specified - all the STUDYID values from TS where TSVAL
for TSPARMCD 'STSTDTC' is equal to or earlier than the are date are extracted
and returned.\cr

If a data table with a list of studies is specified in \code{studyList}, only
the subset of studies included in that set is processed.\cr

If input \code{inclUncertain} is TRUE, uncertain studies are included in the
output set. These uncertain situations are identified and reported (in column
UNCERTAIN_MSG):
\itemize{
\item TS contains now row for TSPARMCD='STSTDTC'
\item TSVAL contains an invalid ISO8601 date format for TSPARMCD='STSTDTC'
}
The same checks are performed and reported in column NOT_VALID_MSG if
\code{fromDTC} and \code{toDTC} are empty and
\code{noFilterReportUncertain=TRUE}.
}
\examples{
\dontrun{
GetStudyListSTSTDTC(myDbToken, allSTudies, '2018','2020')
}
}
