% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summarize_sensitivity}
\alias{summarize_sensitivity}
\title{Sensitivity Summary}
\usage{
summarize_sensitivity(
  weights = NULL,
  Y = NULL,
  Z = NULL,
  b_star = 0,
  estimate = NULL,
  SE = NULL,
  unweighted = NULL,
  sigma2 = NULL,
  estimand = "ATT",
  pretty = FALSE,
  svy_srs = NULL,
  svy_wt = NULL,
  sig.fig = 2
)
}
\arguments{
\item{weights}{Vector of estimated weights}

\item{Y}{Outcome of interest}

\item{Z}{Treatment assignment (Not needed for settings when users are analyzing surveys)}

\item{b_star}{Killer confounder threshold. If not specified, will be automatically set to 0.}

\item{estimate}{(Optional) Weighted point estimate. If not specified, function will automatically generate the weighted estimator, given the inputs in \code{Y} and \code{weights}}

\item{SE}{(Optional) Standard error associated with the weighted point estimate}

\item{unweighted}{(Optional) Unweighted point estimate.}

\item{sigma2}{(Optional) Variance of outcomes or individual-level treatment effect in PATE case. In the case of a PATE estimator, if not specified, function will automatically estimate an upper bound for the variance of the individual-level treatment effect.}

\item{estimand}{Specifies estimand; possible parameters include "ATT", "PATE", or "Survey"}

\item{pretty}{If set to \code{TRUE}, will return a Kable table. If set to \code{FALSE}, will return a data.frame.}

\item{svy_srs}{Unweighted \code{svymean} object}

\item{svy_wt}{Weighted \code{svymean} object}

\item{sig.fig}{Significant figures to round the output to (default set to 2)}
}
\value{
Sensitivity summary
}
\description{
Returns a data.frame or Kable table with summary measures of sensitivity
}
\examples{
data(jtpa_women)
site_name <- "NE"
df_site <- jtpa_women[which(jtpa_women$site == site_name), ]
df_else <- jtpa_women[which(jtpa_women$site != site_name), ]

# Estimate unweighted estimator:
model_dim <- estimatr::lm_robust(Y ~ T, data = df_site)
PATE <- coef(lm(Y ~ T, data = df_else))[2]
DiM <- coef(model_dim)[2]
# Generate weights using observed covariates:
df_all <- jtpa_women
df_all$S <- ifelse(jtpa_women$site == "NE", 1, 0)
model_ps <- WeightIt::weightit(
  (1 - S) ~ . - site - T - Y, 
  data = df_all, method = "ebal", estimand = "ATT"
)
weights <- model_ps$weights[df_all$S == 1]
# Estimate IPW model:
model_ipw <- estimatr::lm_robust(Y ~ T, data = df_site, weights = weights)
ipw <- coef(model_ipw)[2]
# Estimate bound for var(tau):
vartau <- var(df_site$Y[df_site$T == 1]) - var(df_site$Y[df_site$T == 0])
summarize_sensitivity(weights = weights, 
Y = df_site$Y, 
Z = df_site$T, 
sigma2 = vartau,
 estimand = "PATE")
}
