% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.sensiInflu.R
\name{sensi_plot.sensiInflu.TraitEvol}
\alias{sensi_plot.sensiInflu.TraitEvol}
\title{Graphical diagnostics for class 'sensiInflu.TraitEvol'}
\usage{
\method{sensi_plot}{sensiInflu.TraitEvol}(x, graphs = "all", ...)
}
\arguments{
\item{x}{output from \code{influ_discrete} or \code{influ_continuous}}

\item{graphs}{choose which graph should be printed in the output ("all", "q12", "q21", "aic" or" "optpar")}

\item{...}{further arguments to methods}
}
\description{
\code{sensi_plot.sensiTree.TraitEvol} Plot results from \code{influ_discrete} and \code{influ_continuous}.
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link[sensiPhy]{influ_discrete}}
\code{\link[sensiPhy]{influ_continuous}}

The following graphs are printed. 

\strong{Graph aicc:} Distribution of estimated AICc-values across all single-species deletions. 
Red vertical line represents the mean signal among all estimates. 
Blue vertical line represents the median signal among all estimates. 

\strong{Graph optpar:} Distribution of estimated values for optimisation parameter specified using 'transform' (if applicable)
Red vertical line represents the mean signal among all estimates. 
Blue vertical line represents the median signal among all estimates. 

Additionally, only for \code{tree_discrete} the function creates the following graphs. 

\strong{Graph q12:} Distribution of estimated parameter values for transition rates q12 across all single-species deletions. 
Red vertical line represents the mean signal among all estimates. 
Blue vertical line represents the median signal among all estimates. 

\strong{Graph q21:} Distribution of estimated parameter values for transition rates q21. 
Red vertical line represents the mean signal among all estimates. 
Blue vertical line represents the median signal among all estimates. 

While only for \code{tree_continuous} the function creates the following graphs. 

\strong{Graph sigsq:} Distribution of estimated parameter values for rate of evolution sigsq across all single-species deletions. .
Red vertical line represents the mean signal among all estimates. 
Blue vertical line represents the median signal among all estimates. 

\strong{Graph z0:} Distribution of estimated parameter values for z0.
Red vertical line represents the mean signal among all estimates. 
Blue vertical line represents the median signal among all estimates.
}
\author{
Gijsbert Werner
}
