% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_helpers.R
\name{format_large_number}
\alias{format_large_number}
\title{Format large numbers with K/M/B suffixes}
\usage{
format_large_number(val, digits = 1, prefix = "")
}
\arguments{
\item{val}{Numeric value to format}

\item{digits}{Number of digits after decimal for millions/billions (default: 1)}

\item{prefix}{Optional prefix (e.g., "$" for currency)}
}
\value{
Formatted string with appropriate suffix
}
\description{
Format large numbers with K/M/B suffixes
}
\examples{
format_large_number(1234567)      # "1.2M"
format_large_number(1234567890)   # "1.2B"
format_large_number(1234567, prefix = "$") # "$1.2M"
}
