% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_app_lookup.R
\name{st_app_lookup}
\alias{st_app_lookup}
\title{Look up app information by any ID type}
\usage{
st_app_lookup(
  app_id,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = FALSE
)
}
\arguments{
\item{app_id}{Character string. Can be:
- Sensor Tower unified app ID (24-char hex like "5ba4585f539ce75b97db6bcb")
- iOS app ID (numeric like "943599237")
- Android package name (like "com.bandainamcogames.dbzdokkanww")}

\item{auth_token}{Character string. Your Sensor Tower API authentication token.}

\item{verbose}{Logical. Whether to show progress messages. Default is FALSE.}
}
\value{
A list with components:
  - `unified_app_id`: The Sensor Tower unified app ID
  - `ios_app_id`: iOS app ID if found
  - `android_app_id`: Android app ID if found
  - `app_name`: App name if found
  - `publisher_name`: Publisher name if found
  Returns NULL if app cannot be found.
}
\description{
This function looks up app information using any type of app ID - unified,
iOS, or Android. It returns the unified ID and platform-specific IDs that 
can be used with other API functions.
}
\details{
The function automatically detects the ID type:
- 24-character hex strings are treated as unified IDs
- Numeric strings are treated as iOS app IDs
- Strings starting with com/net/org/io are treated as Android package names
}
\examples{
\dontrun{
# Look up Star Trek Fleet Command
app_ids <- st_app_lookup("5ba4585f539ce75b97db6bcb")

# Use the IDs with st_ytd_metrics
if (!is.null(app_ids)) {
  metrics <- st_ytd_metrics(
    ios_app_id = app_ids$ios_app_id,
    android_app_id = app_ids$android_app_id,
    years = 2025,
    metrics = "revenue",
    countries = "WW"
  )
}
}

}
