% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_categories.R
\name{st_categories}
\alias{st_categories}
\title{List Available Sensor Tower Categories}
\usage{
st_categories(platform = NULL)
}
\arguments{
\item{platform}{Optional character string. Filter results for a specific
platform ("ios" or "android"). If NULL (default), returns categories for
both platforms.}
}
\value{
A tibble with columns `platform` (character, "ios" or "android"),
  `category_id` (character, e.g., "6014"), and `category_name`
  (character, e.g., "Games").
}
\description{
Returns a tibble of app categories recognized by the Sensor Tower API,
mapping category IDs to category names for different platforms (iOS/Android).
Useful for finding valid inputs for the `category` parameter in other
functions.
}
\examples{
# Get all categories
all_cats <- st_categories()
head(all_cats)

# Get only iOS categories
ios_cats <- st_categories(platform = "ios")
head(ios_cats)

# Find game categories on iOS
ios_games <- subset(st_categories("ios"), grepl("Game", category_name))
head(ios_games)
}
