% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_workflow.R
\name{st_create_simple_filter}
\alias{st_create_simple_filter}
\title{Create or Get Filter ID for Custom Criteria}
\usage{
st_create_simple_filter(
  field_name,
  field_values,
  global = TRUE,
  exclude = FALSE,
  auth_token = NULL
)
}
\arguments{
\item{field_name}{Character. Name of the custom field to filter by}

\item{field_values}{Character vector. Values to filter for}

\item{global}{Logical. Whether this is a global field (TRUE) or organization field (FALSE)}

\item{exclude}{Logical. Whether to exclude apps matching criteria (FALSE = include)}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
Character string containing the filter ID
}
\description{
Creates a custom fields filter or retrieves existing filter ID if the same
criteria already exists. This is a convenience wrapper around st_custom_fields_filter.
}
\examples{
\dontrun{
# Get filter ID for Word games
filter_id <- st_create_simple_filter(
  field_name = "Game Sub-genre",
  field_values = "Word"
)

# Get filter ID for multiple genres
filter_id <- st_create_simple_filter(
  field_name = "Game Genre",
  field_values = c("Puzzle", "Word")
)
}

}
