% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields.R
\name{st_custom_fields_filter_by_id}
\alias{st_custom_fields_filter_by_id}
\title{Get Custom Fields Filter Details by ID}
\usage{
st_custom_fields_filter_by_id(
  id,
  auth_token = NULL,
  base_url = "https://api.sensortower.com"
)
}
\arguments{
\item{id}{Character string. The custom fields filter ID to query.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{base_url}{Optional. Character string. The base URL for the API.}
}
\value{
A list containing the custom fields filter details
}
\description{
Retrieves the custom field names and tag values associated with a 
Custom Fields Filter ID.
}
\examples{
\dontrun{
# Get details for a specific filter ID
filter_details <- st_custom_fields_filter_by_id(
  id = "6009d417241bc16eb8e07e9b"
)
}

}
