% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_workflow.R
\name{st_discover_fields}
\alias{st_discover_fields}
\title{Discover Available Custom Fields}
\usage{
st_discover_fields(search_term = NULL, show_values = FALSE, auth_token = NULL)
}
\arguments{
\item{search_term}{Optional. Character string to search for in field names}

\item{show_values}{Logical. Whether to show possible values for each field}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
A tibble with custom fields information
}
\description{
Searches and displays available custom fields that can be used for filtering.
This is helpful for discovering what fields are available before creating filters.
}
\examples{
\dontrun{
# Find all game-related fields
game_fields <- st_discover_fields("game")

# Find all date fields
date_fields <- st_discover_fields("date")

# Show all fields with their values
all_fields <- st_discover_fields(show_values = TRUE)
}

}
