% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_utils.R
\name{st_filter_by_sdk}
\alias{st_filter_by_sdk}
\title{Create SDK-Based Filter}
\usage{
st_filter_by_sdk(sdk_names, exclude = FALSE, auth_token = NULL)
}
\arguments{
\item{sdk_names}{Character vector. SDK names to filter (e.g., "Unity", "Firebase")}

\item{exclude}{Logical. Whether to exclude apps with these SDKs}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
Character string containing the filter ID
}
\description{
Creates a filter for apps using specific SDKs or technologies.
}
\examples{
\dontrun{
# Get Unity-based games
filter_id <- st_filter_by_sdk(sdk_names = "Unity")

# Get apps using both Firebase and AdMob
filter_id <- st_filter_by_sdk(
  sdk_names = c("Firebase", "AdMob")
)
}

}
