% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_workflow.R
\name{st_get_filtered_apps}
\alias{st_get_filtered_apps}
\title{Get Top Apps with Custom Filter}
\usage{
st_get_filtered_apps(
  field_name = NULL,
  field_values = NULL,
  filter_id = NULL,
  measure = "DAU",
  regions = "US",
  date = NULL,
  end_date = NULL,
  limit = 100,
  enrich_response = TRUE,
  auth_token = NULL,
  ...
)
}
\arguments{
\item{field_name}{Character. Name of the custom field to filter by (or NULL to use filter_id)}

\item{field_values}{Character vector. Values to filter for (or NULL to use filter_id)}

\item{filter_id}{Character. Existing filter ID to use (alternative to field_name/values)}

\item{measure}{Character. Metric to measure: "DAU", "WAU", "MAU", "revenue", or "units"}

\item{regions}{Character vector. Region codes (e.g., "US", "WW")}

\item{date}{Character or Date. Start date for the query}

\item{end_date}{Optional. Character or Date. End date for the query}

\item{limit}{Integer. Maximum number of apps to return (default 100)}

\item{enrich_response}{Logical. Whether to enrich with additional metrics}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{...}{Additional parameters passed to st_top_charts}
}
\value{
A tibble with top apps data
}
\description{
Retrieves top apps using a custom fields filter. This combines filter creation
with data retrieval in a single workflow.
}
\examples{
\dontrun{
# Get top Word games by DAU
word_games <- st_get_filtered_apps(
  field_name = "Game Sub-genre",
  field_values = "Word",
  measure = "DAU",
  regions = "US",
  limit = 20
)

# Use existing filter ID
apps <- st_get_filtered_apps(
  filter_id = "603697f4241bc16eb8570d37",
  measure = "revenue",
  regions = "US"
)
}

}
