% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_sales_report.R
\name{st_sales_report}
\alias{st_sales_report}
\title{Fetch Sales Report Estimates}
\usage{
st_sales_report(
  os,
  countries,
  start_date,
  end_date,
  date_granularity,
  ios_app_id = NULL,
  android_app_id = NULL,
  unified_app_id = NULL,
  publisher_ids = NULL,
  custom_fields_filter_id = NULL,
  custom_tags_mode = NULL,
  limit = 100,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  auto_segment = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{os}{Character string. Required. Operating system: "ios", "android", or "unified".}

\item{countries}{Character vector. Country codes (e.g., c("US", "GB", "JP"), or "WW" for worldwide). Required.}

\item{start_date}{Date or character string. Start date in "YYYY-MM-DD" format. Required.}

\item{end_date}{Date or character string. End date in "YYYY-MM-DD" format. Required.}

\item{date_granularity}{Character string. One of "daily", "weekly", "monthly", "quarterly". Required.}

\item{ios_app_id}{Character string. iOS app ID (numeric, e.g., "1234567890").}

\item{android_app_id}{Character string. Android package name (e.g., "com.example.app").}

\item{unified_app_id}{Character string. Sensor Tower unified app ID (24-character hex).}

\item{publisher_ids}{Character vector. Publisher IDs to query. Some Android publisher IDs contain commas.}

\item{custom_fields_filter_id}{Optional. Character string. ID of a Sensor
Tower custom field filter to apply. Use filter IDs from the web interface
at app.sensortower.com. When provided, this filter will be used instead of
app_ids or publisher_ids.}

\item{custom_tags_mode}{Optional. Character string. Required if `os` is
'unified' and `custom_fields_filter_id` is provided. Specifies how the
custom filter applies to unified apps. Options: "include", "exclude",
"include_unified_apps". The "include_unified_apps" option includes all
platform versions when any version matches the filter.}

\item{limit}{Numeric. Number of results to return when using custom_fields_filter_id.
Ignored when using specific app ID parameters or publisher_ids. Defaults to 100.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{auto_segment}{Logical. If TRUE, automatically segments date ranges to avoid timeouts.}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
A tibble with download and revenue estimates.
}
\description{
Retrieves download and revenue estimates of apps by country and date.
Note: All revenues are returned in cents and need to be divided by 100 for dollar amounts.
}
\details{
**App ID Parameters**: Provide one of the following:
- `ios_app_id`: Specifically for iOS app IDs (numeric)
- `android_app_id`: Specifically for Android package names
- `unified_app_id`: Specifically for Sensor Tower unified IDs

The function will automatically resolve IDs if needed. For example, if you provide
a `unified_app_id` but set `os="ios"`, it will look up the iOS app ID.

The API has timeout limitations based on date granularity:
- daily: limit to 1 week segments
- weekly: limit to 3 month segments  
- monthly: limit to 1 year segments
- quarterly: limit to 2 year segments

When auto_segment = TRUE, the function automatically breaks up the date range
into appropriate segments and combines the results.
}
\examples{
\dontrun{
# Get daily sales for a single app using specific parameter
sales <- st_sales_report(
  os = "ios",
  ios_app_id = "553834731",  # Candy Crush iOS
  countries = c("US", "GB"),
  start_date = "2024-01-01",
  end_date = "2024-01-07",
  date_granularity = "daily"
)

# Get Android data using specific parameter
android_sales <- st_sales_report(
  os = "android",
  android_app_id = "com.king.candycrushsaga",
  countries = "US",
  start_date = "2024-01-01",
  end_date = "2024-01-07",
  date_granularity = "daily"
)

# Get iOS data from unified ID (automatic lookup)
unified_sales <- st_sales_report(
  os = "ios",
  unified_app_id = "5ba4585f539ce75b97db6bcb",
  countries = "US",
  start_date = "2024-01-01",
  end_date = "2024-01-07",
  date_granularity = "daily"
)

}

}
