% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_soundSample.R
\name{as.soundSample}
\alias{as.soundSample}
\title{Cast to a sound sample}
\usage{
as.soundSample(w, pan = 0)
}
\arguments{
\item{w}{tuneR Wave object}

\item{pan}{Numeric in [-1;1], panoramic. -1 (resp. 1) only select the left
(resp. right) channel of w (if the latter is stereo). 0 averages both channels}
}
\value{
An object of class 'soundSample'.
}
\description{
Convert a tuneR::Wave object into a soundSample.
}
\examples{
w <- tuneR::Wave(left=sin(2*pi*seq(0,1,,44100)*440)) # 1-second A
sam <- as.soundSample(w)
plot(sam)
}
