% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPRT.R
\name{sprt}
\alias{sprt}
\title{Sequential Probability Ratio Test}
\usage{
sprt(data = NA, mu0, mu1, density_func, overdispersion, alpha, beta)
}
\arguments{
\item{data}{Optional vector of count data (NAs not allowed). Each value is
considered a sampling bout over time. Can't process group sequential data.
If not provided (NA), returns a \code{"SPRT"} object that can be used to plot
a chart with stop lines or to return stop lines coefficients. If provided, returns
a \code{"SPRT"} object that can be used to plot a chart with stop lines and data
or to return test summary.}

\item{mu0}{Single non-negative number with the value for the low
hypothesized population density, \eqn{\psi_{0}}.}

\item{mu1}{Single non-negative number with the value for the high
hypothesized population density, \eqn{\psi_{1}}.}

\item{density_func}{Kernel probability density function for the data. See
details.}

\item{overdispersion}{A number specifying the overdispersion parameter.
Only required when using \code{"negative binomial"} as kernel density.
See details.}

\item{alpha}{Single number indicating tolerable type I error rate.}

\item{beta}{Single number indicating tolerable type II error rate.}
}
\value{
An object of class \code{"SPRT"}.
}
\description{
Runs a Sequential Probability Ratio Test for hypotheses
about population densities of the form \eqn{H_{0}:\mu = \psi_{0}} vs.
\eqn{H_{1}:\mu < \psi_{1}}, where \eqn{\psi_{0} < \psi_{1}}. Data is treated
in a sequential framework.
}
\details{
The \code{density_func} argument should be specified as character string.
Acceptable options are \code{"poisson"}, \code{"negative binomial"}, and
\code{"binomial"}. As far as we know, no one has ever calculated and published stop
lines for the beta-binomial family. The overdispersion parameter should only be
specified as a constant. In contrast to the STBP, SPRT is only use overdispersion
to calculate stop lines, so the estimate for the threshold population density
should be used (e.g., at \eqn{\psi_{0} < \psi < \psi_{1}}).
}
\examples{

# If no data is provided, an object of class "SPRT" is returned from which a
# chart with stop lines or a summary of the test with coefficients for stop lines
# can be extracted.

test00 <- sprt(mu0 = 2,
                mu1 = 4,
                density_func = "negative binomial",
                overdispersion = 4.6,
                alpha = 0.1,
                beta = 0.1)

test00 # returns test specification and stop lines coefficients
plot(test00) # returns a chart with stop lines


# If data is provided, an object of class "SPRT" is returned with test results.

counts <- c(2, 5, 6, 2, 7)

test11 <- sprt(data = counts,
                mu0 = 2,
                mu1 = 4,
                density_func = "negative binomial",
                overdispersion = 4.6,
                alpha = 0.1,
                beta = 0.1)
test11 # returns "accept H1" after 5 sampling bouts processed.

## End (Not run)

}
\references{
Binns, M.R., Nyrop, J.P. & Werf, W.v.d. (2000) \emph{Sampling and
monitoring in crop protection: the theoretical basis for developing practical
decision guides}. CABI Pub., Wallingford, Oxon, UK; New York, N.Y.

Wald, A. (1945) Sequential Tests of Statistical Hypotheses. \emph{The Annals
of Mathematical Statistics} 16(2): 117-186.
}
