% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindFamilies.R
\name{FindFamilies}
\alias{FindFamilies}
\title{Assign Family IDs}
\usage{
FindFamilies(Pedigree = NULL, SeqList = NULL, MaybeRel = NULL)
}
\arguments{
\item{Pedigree}{dataframe with columns id - parent1 - parent2; only the
first 3 columns will be used.}

\item{SeqList}{list as returned by \code{\link{sequoia}}. If \code{Pedigree}
is not provided, the element \code{Pedigree} from this list will be used if
present, and element \code{Pedigreepar} otherwise.}

\item{MaybeRel}{Output from \code{\link{GetMaybeRel}}, a dataframe with
probable but non-assigned relatives.}
}
\value{
A numeric vector with length equal to the number of unique
  individuals in the pedigree (i.e. number of rows in pedigree after running
  \code{\link{PedPolish}} on \code{Pedigree}).
}
\description{
Find clusters of connected individuals in a pedigree, and assign
  each cluster a unique family ID (FID).
}
\details{
This function repeatedly finds all ancestors and all descendants of
 each individual in turn, and ensures they all have the same Family ID. Not
 all connected individuals are related, e.g. all grandparents of an
 individual will have the same FID, but will typically be unrelated.

When \code{UseMaybeRel = TRUE}, probable relatives are added to existing
family clusters, or existing family clusters may be linked together.
Currently no additional family clusters are created.
}
\examples{

PedG <- SeqOUT_griffin$PedigreePar[,1:3]
FID_G <- FindFamilies(PedG)
PedG[FID_G==4,]
}
\seealso{
\code{\link{GetAncestors}, \link{GetDescendants},
  \link{getGenerations}}
}
