#' Chikungunya seroprevalence data in serofoi
#'
#' Datasets that measure the seroprevalence of IgG antibodies against
#' the Chikungunya virus conducted in Bahia, Brazil in October-December
#' 2015 by Dias et al. (2018). The survey was conducted immediately after
#' a large Chikungunya epidemic in the area.
#'
#' @docType data
#'
#' @usage data(chik2015)
#'
#' @format ## `chik2015`
#' A `<data.frame>` with 4 rows and 5 columns:
#' \describe{
#'   \item{survey_year}{Year in which the serosurvey was conducted}
#'   \item{n_sample}{Number of collected samples per age group}
#'   \item{n_seropositive}{Number of positive samples per age group}
#'   \item{age_min}{Age group minimal age}
#'   \item{age_max}{Age group maximal age}
#' }
#'
#' @keywords datasets
#'
#' @examples
#' data(chik2015)
"chik2015"
