% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{plot_serosurvey}
\alias{plot_serosurvey}
\title{Plots seroprevalence from the given serosurvey}
\usage{
plot_serosurvey(
  serosurvey,
  size_text = 11,
  bin_serosurvey = FALSE,
  bin_step = 5
)
}
\arguments{
\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{size_text}{Size of text for plotting (\code{base_size} in
\link[ggplot2:ggtheme]{ggplot2})}

\item{bin_serosurvey}{If \code{TRUE}, \code{serodata} is binned by means of
\code{prepare_bin_serosurvey}.
Otherwise, age groups are kept as originally input.}

\item{bin_step}{Integer specifying the age groups bin size to be used when
\code{bin_serosurvey} is set to \code{TRUE}.}
}
\value{
ggplot object with seroprevalence plot
}
\description{
Plots seroprevalence from the given serosurvey
}
\examples{
# Chikungunya example serosurvey
data(chik2015)
plot_serosurvey(chik2015)

# VEEV example serosurvey
data(veev2012)
plot_serosurvey(veev2012)
}
