% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_seromodel.R
\name{summarise_loo_estimate}
\alias{summarise_loo_estimate}
\title{Extract specified loo estimate}
\usage{
summarise_loo_estimate(
  seromodel,
  par_loo_estimate = "elpd_loo",
  loo_estimate_digits = 2
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{par_loo_estimate}{Name of the loo estimate to be extracted.
Available options are:
\describe{
\item{\code{"elpd_loo"}}{Expected log pointwise predictive density}
\item{\code{"p_loo"}}{Effective number of parameters}
\item{\code{"looic"}}{Leave-one-out cross-validation information criteria}
}
For additional information refer to \link[loo:loo]{loo}.}

\item{loo_estimate_digits}{Number of loo estimate digits}
}
\value{
Text summarising specified loo estimate
}
\description{
Extract specified loo estimate
}
\examples{
data(veev2012)
seromodel <- fit_seromodel(veev2012, iter = 100)
summarise_loo_estimate(seromodel)
}
