% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional_polynomial_models.R
\name{fp_model}
\alias{fp_model}
\title{A fractional polynomial model.}
\usage{
fp_model(data, p, link = "logit")
}
\arguments{
\item{data}{the input data frame, must either have `age`, `pos`, `tot` columns (for aggregated data) OR `age`, `status` for (linelisting data)}

\item{p}{the powers of the predictor.}

\item{link}{the link function for model. Defaulted to "logit".}
}
\value{
a list of class fp_model with 5 items
  \item{datatype}{type of data used for fitting model (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{info}{a fitted glm model}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Refers to section 6.2.
}
\examples{
df <- hav_be_1993_1994
model <- fp_model(
  df,
  p=c(1.5, 1.6), link="cloglog")
plot(model)

}
\seealso{
[stats::glm()] for more information on glm object
}
