% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_expand.R
\name{sfc_expand,sfc_2x2-method}
\alias{sfc_expand,sfc_2x2-method}
\alias{sfc_expand}
\alias{sfc_expand,sfc_3x3_peano-method}
\alias{sfc_expand,sfc_3x3_meander-method}
\title{Expand the curve to the next level}
\usage{
\S4method{sfc_expand}{sfc_2x2}(p, code, flip = FALSE)

\S4method{sfc_expand}{sfc_3x3_peano}(p, code = 1, flip = FALSE)

\S4method{sfc_expand}{sfc_3x3_meander}(p, code, flip = FALSE)
}
\arguments{
\item{p}{An \code{sfc_2x2} object or other related objects.}

\item{code}{Expansion code, a single integer.}

\item{flip}{Whethe to flip level-1 units? The value should be a logical vector of length one or the same as the length of \code{p}.}
}
\value{
An object in the same class as the input.
}
\description{
Expand the curve to the next level
}
\details{
For the Hilbert curve and Meander curve, as long as the expansion code of the first base pattern in the sequence is determinted,
the expansion codes for other base patterns in the sequence are all determined. For the Peano curve, since
there is only one traverse path on any level, \code{code} is ignored.

These functions are mainly used internally.
}
\examples{
p = sfc_2x2("I", 11)
sfc_expand(p, 2) # I|211
p = sfc_3x3_peano("I", 11)
sfc_expand(p, 2) # I|211
p = sfc_3x3_meander("I", 11)
sfc_expand(p, 2) # I|211
}
