% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_design.R
\name{sfd_available}
\alias{sfd_available}
\title{Is a Space-Filling Design Available?}
\usage{
sfd_available(num_param, num_points, type = "any")
}
\arguments{
\item{num_param}{An integer between two and ten for the number of
characteristics/factors/parameters in the design.}

\item{num_points}{An integer for the number of grid points requested. If
there is no corresponding design, an error is given (when using
\code{get_design()})}

\item{type}{A character string with possible values> \code{"any"},
\code{"audze_eglais"}, \code{"max_min_l1"}, \code{"max_min_l2"}, and \code{"uniform"}. A value
of \code{"any"} will choose the first design available (in alphabetical order).}
}
\value{
A logical
}
\description{
Determine if a design from
\url{https://www.spacefillingdesigns.nl/}
is available in this package based on how many characteristics (i.e.
parameters), size (i.e., number of grid points), and type.
}
\examples{
sfd_available(2, 10)
sfd_available(2, 10^5)
}
