% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_set_gcs.R
\encoding{UTF-8}
\name{sgo_set_gcs}
\alias{sgo_set_gcs}
\title{Set GCS of a set of points}
\usage{
sgo_set_gcs(x, to = NULL)
}
\arguments{
\item{x}{A \code{sgo_points} object describing a set of points in a geodetic
coordinate system.}

\item{to}{Specifies the EPSG code to convert the coordinates to. Currently it
can take any of the following values: \code{4258}, \code{4937}, \code{4936},
\code{4326}, \code{4979}, \code{4978} or \code{4277}.}
}
\value{
An object of class 'sgo_points'.
}
\description{
Changes the geodetic coordinate system of a set of points using a single
Helmert transformation.
}
\details{
Changes the geodetic coordinate system of a set of points. Note that the
precision of various datums will vary, and the original WGS-84 is not defined
to be accurate to better than ±1 metre. Most transformations shouldn't be
assumed to be accurate to better than a meter; between OSGB36 and WGS84
somewhat less - the lost of accuracy can be up to ±5m when using single
Helmert transformations.

Input points with a projected coordinate system (e.g. 27700, 7405, 3035 or
3857) are not allowed.

\strong{Warning}
This function is mainly for internal use of the program. Since it relies on a
single Helmert transformation it is not recommended to call it directly. Use
any other of the transformation functions available (\link{sgo-package}).
}
\examples{
lon <- c(-4.25181,-3.18827)
lat <- c(55.86424, 55.95325)
p <- sgo_points(list(longitude=lon, latitude=lat), epsg=4326)
# warning: a single Helmert transformation is used in the next transformation
p2 <- sgo_set_gcs(p, to=4277)
# if higher precision is required to transform between OSGB36 lon/lat and
# ETRS89/WGS84 lon/lat then use the OSTN15 transformation (will be slower):
# Transform from WGS84 lon/lat coordinates to EPSG:4277 using OSTN15
p2 <- sgo_transform(p, to=4277)
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_transform}}.
}
