% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{shape2scatter}
\alias{shape2scatter}
\title{Scatter Estimates from \code{shapeNA} Objects}
\usage{
shape2scatter(obj)
}
\arguments{
\item{obj}{\code{shapeNA} object, resulting from a call to
\code{\link{powerShape}} and other functions from the same family.}
}
\value{
Scatter matrix estimate, or only \code{NA} if \code{alpha} = 1.
}
\description{
For Power M-estimates with tail index \code{alpha < 1}, the resulting estimate
has a scale. For these shape estimates, scatter matrices can be computed.
Results from
\code{\link{tylerShape}} and \code{\link{tylerShapeNA}} give no scatter
estimates. In these cases the function returns \code{NA}.
}
\examples{
    S <- toeplitz(c(1, 0.3, 0.7))
    set.seed(123)
    x <- mvtnorm::rmvt(100, S, df = 3)
    obj_det <- powerShape(x, alpha = 0.85, normalization = 'det')
    shape2scatter(obj_det)
    obj_tr <- powerShape(x, alpha = 0.85, normalization = 'trace')
    shape2scatter(obj_tr)
    obj_one <- powerShape(x, alpha = 0.85, normalization = 'one')
    shape2scatter(obj_one)
}
