% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_point_process.R
\name{fit_point_process}
\alias{fit_point_process}
\title{fit_point_process}
\usage{
fit_point_process(
  pattern,
  n_random = 1,
  process = "poisson",
  return_para = FALSE,
  return_input = TRUE,
  simplify = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{pattern}{ppp object with point pattern}

\item{n_random}{Integer with number of randomizations.}

\item{process}{Character specifying which point process model to use.
Either \code{"poisson"} or \code{"cluster"}.}

\item{return_para}{Logical if fitted parameters should be returned.}

\item{return_input}{Logical if the original input data is returned.}

\item{simplify}{Logical if only pattern will be returned if \code{n_random = 1}
and \code{return_input = FALSE}.}

\item{verbose}{Logical if progress report is printed.}
}
\value{
rd_pat
}
\description{
Fit point process to randomize data
}
\details{
The functions randomizes the observed point pattern by fitting a point process to
the data and simulating \code{n_random} patterns using the fitted point process.
It is possible to choose between a Poisson process or a Thomas cluster process model.
For more information about the point process models, see e.g. Wiegand & Moloney (2014).
}
\examples{
pattern_fitted <- fit_point_process(pattern = species_a, n_random = 39)

}
\references{
Plotkin, J.B., Potts, M.D., Leslie, N., Manokaran, N., LaFrankie, J.V.,
Ashton, P.S., 2000. Species-area curves, spatial aggregation, and habitat specialization
in tropical forests. Journal of Theoretical Biology 207, 81–99.
<https://doi.org/10.1006/jtbi.2000.2158>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton. ISBN 978-1-4200-8254-8
}
