% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdate.R, R/jdatetime.R
\name{shide-math}
\alias{shide-math}
\alias{vec_math.jdate}
\alias{vec_math.jdatetime}
\title{Mathematical operations for \code{jdate} and \code{jdatetime}}
\usage{
\method{vec_math}{jdate}(.fn, .x, ...)

\method{vec_math}{jdatetime}(.fn, .x, ...)
}
\arguments{
\item{.fn}{A mathematical function from the base package, as a string.}

\item{.x}{A vector of \code{jdate} or \code{jdatetime} objects.}

\item{...}{Additional arguments passed to .fn.}
}
\value{
For \code{is.finite()} and \code{is.infinite()}, a logical vector of the same length as x.
Using all the other math and summary group generics will signal an error.
}
\description{
Math and Summary group of functions for \code{jdate} and \code{jdatetime} objects.
Only methods for \code{is.finite()} and \code{is.infinite()} are provided and other functions from
the groups, such as \code{mean()}, \code{median()} and \code{summary()} are not implemented.
}
\details{
\code{vctrs} implementation of \code{Date} and \code{POSIXct} does not include methods for
\code{is.finite()} and \code{is.infinite()}. But these method are implemented in \code{shide}
so that \code{jdate} and \code{jdatetime} vectors could be used as \code{ggplot} scales.
}
\examples{
# Unlike a `Date` vector, `mean()` is not defined for a `jdate` vector
try(mean(c(jdate_now(), jdate_now() + 2)))
}
