% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{MultistepDialog}
\alias{MultistepDialog}
\alias{DialogStep}
\title{Multistep dialog}
\usage{
MultistepDialog(...)

DialogStep(...)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/dialog.multistep-dialog}
}
\examples{
library(shiny.blueprint)
library(shiny)

ui <- function(id) {
  ns <- NS(id)
  tagList(
    Button.shinyInput(
      inputId = ns("showMultistepDialog"),
      "Show multistep dialog"
    ),
    reactOutput(ns("multistepDialog"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    ns <- session$ns

    isOpen <- reactiveVal(FALSE)
    observeEvent(input$showMultistepDialog, isOpen(TRUE))
    observeEvent(input$closeMultistepDialog, isOpen(FALSE))

    output$multistepDialog <- renderReact({
      MultistepDialog(
        usePortal = FALSE,
        isOpen = isOpen(),
        title = "Multistep dialog",
        onClose = triggerEvent(ns("closeMultistepDialog")),
        DialogStep(
          id = "step1",
          panel = div(
            className = "bp5-dialog-body",
            p("This is a step 1")
          ),
          title = "Step 1"
        ),
        DialogStep(
          id = "step2",
          panel = div(
            className = "bp5-dialog-body",
            p("This is a step 2")
          ),
          title = "Step 2"
        ),
        DialogStep(
          id = "step3",
          panel = div(
            className = "bp5-dialog-body",
            p("This is a step 3")
          ),
          title = "Step 3"
        )
      )
    })
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
