% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongo_connector.R
\docType{class}
\name{RegLogMongoConnector}
\alias{RegLogMongoConnector}
\title{Connector to MongoDB database}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Object of this class handles all connections for the RegLogServer object to
the database. It is created to handle MongoDB database compatible drivers.
Provides methods than will be used by RegLogServer to get and send data.

Requires \code{mongolite} package to be installed.
}
\section{Super class}{
\code{\link[shiny.reglog:RegLogConnector]{shiny.reglog::RegLogConnector}} -> \code{RegLogMongoConnector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RegLogMongoConnector-new}{\code{RegLogMongoConnector$new()}}
\item \href{#method-RegLogMongoConnector-clone}{\code{RegLogMongoConnector$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="get_logs"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-get_logs'><code>shiny.reglog::RegLogConnector$get_logs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="resume"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-resume'><code>shiny.reglog::RegLogConnector$resume()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="suspend"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-suspend'><code>shiny.reglog::RegLogConnector$suspend()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogMongoConnector-new"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogMongoConnector-new}{}}}
\subsection{Method \code{new()}}{
Initialization of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogMongoConnector$new(
  mongo_url,
  mongo_db,
  mongo_options = mongolite::ssl_options(),
  collections = c("account", "reset_code", "logs"),
  custom_handlers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mongo_url}}{URI to the MongoDB cluster}

\item{\code{mongo_db}}{name of the MongoDB database}

\item{\code{mongo_options}}{additional connection options such as SSL keys/certs}

\item{\code{collections}}{names of the collections}

\item{\code{custom_handlers}}{named list of custom handler functions. Every
custom handler should take arguments: \code{self} and \code{private} - relating to
the R6 object and \code{message} of class \code{RegLogConnectorMessage}. It should
return \code{RegLogConnectorMessage} object.}

\item{\code{table_names}}{character vector. Contains names of the collections in the
database: first containing user data, second - reset codes information,
third (optional) - logs from the object. For more info check documentation
of \code{mongo_database_create}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of \code{RegLogMongoConnector} class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogMongoConnector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogMongoConnector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogMongoConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
