% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twCheckboxInput.R
\name{twCheckboxInput}
\alias{twCheckboxInput}
\title{Wrapper around \code{\link[shiny:checkboxInput]{shiny::checkboxInput()}} but allowing for more classes}
\usage{
twCheckboxInput(
  inputId,
  label,
  value = FALSE,
  width = NULL,
  disabled = FALSE,
  container_class = NULL,
  label_class = NULL,
  input_class = NULL,
  center = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value (\code{TRUE} or \code{FALSE}).}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{disabled}{if the user should not be able to interact with the field}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{input_class}{additional classes to be applied to the input element}

\item{center}{if a margin of 0px !important should be applied, effectively
removing bootstrap styling (if applied) to center the checkbox easier}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:checkboxInput]{shiny::checkboxInput()}} but allowing for more classes
}
\examples{
shiny::checkboxInput("id", "label", value = FALSE)
twCheckboxInput("id", "label",
  value = TRUE, width = "200px", disabled = TRUE,
  container_class = "CONTAINER", label_class = "LABEL", input_class = "INPUT"
)

# basic full shiny example
library(shiny)

ui <- fluidPage(
  use_tailwind(),
  twCheckboxInput(
    "chk", "Check me!",
    value = TRUE,
    container_class = "w-48 m-4 p-2 border border-gray-200 rounded-md drop-shadow-md",
    label_class = "font-serif text-gray-600",
    input_class = "text-pink-500 focus:ring-pink-500",
    center = TRUE
  ),
  verbatimTextOutput("out")
)

server <- function(input, output) {
  output$out <- renderText({
    input$chk
  })
}

if (interactive()) shiny::shinyApp(ui, server)
}
\seealso{
\code{\link[shiny:checkboxInput]{shiny::checkboxInput()}}
}
