% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twFileInput.R
\name{twFileInput}
\alias{twFileInput}
\title{Wrapper around \code{\link[shiny:fileInput]{shiny::fileInput()}} but allowing for more classes}
\usage{
twFileInput(
  inputId,
  label,
  multiple = FALSE,
  accept = NULL,
  width = NULL,
  buttonLabel = "Browse...",
  placeholder = "No file selected",
  container_class = NULL,
  label_class = NULL,
  select_class = NULL,
  button_class = NULL,
  progress_class = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{multiple}{Whether the user should be allowed to select and upload
multiple files at once. \strong{Does not work on older browsers, including
Internet Explorer 9 and earlier.}}

\item{accept}{A character vector of "unique file type specifiers" which
gives the browser a hint as to the type of file the server expects.
Many browsers use this prevent the user from selecting an invalid file.

A unique file type specifier can be:
\itemize{
\item A case insensitive extension like \code{.csv} or \code{.rds}.
\item A valid MIME type, like \code{text/plain} or \code{application/pdf}
\item One of \verb{audio/*}, \verb{video/*}, or \verb{image/*} meaning any audio, video,
or image type, respectively.
}}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{buttonLabel}{The label used on the button. Can be text or an HTML tag
object.}

\item{placeholder}{The text to show before a file has been uploaded.}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{select_class}{additional classes to be applied to the select elements}

\item{button_class}{additional classes to be applied to the upload button}

\item{progress_class}{additional classes to be applied to the progress bar (ie color)}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:fileInput]{shiny::fileInput()}} but allowing for more classes
}
\examples{
shiny::fileInput("id", "label",
  multiple = TRUE, accept = c(".csv", ".rds"),
  width = "200px", buttonLabel = "Upload", placeholder = "Here"
)
twFileInput("id", "label",
  multiple = TRUE, accept = c(".csv", ".rds"),
  width = "200px", buttonLabel = "Upload", placeholder = "Here",
  container_class = "CONTAINER", label_class = "LABEL",
  select_class = "SELECT"
)

# basic full shiny example
library(shiny)
ui <- fluidPage(
  use_tailwind(),
  twFileInput(
    inputId = "file", label = "Upload", multiple = TRUE,
    buttonLabel = "Upload", placeholder = "Nothing selected",
    container_class = "shadow-md rounded-md bg-gray-50 m-2 p-2 w-96",
    label_class = "font-serif text-red-800",
    select_class = "font-mono font-bold text-red-800 rounded-r-lg",
    button_class = paste(
      "bg-red-800 border-red-800 hover:bg-red-700",
      "hover:border-red-700 text-white hover:text-gray-50"
    ),
    progress_class = "bg-red-800"
  ),
  verbatimTextOutput("data")
)

server <- function(input, output) {
  output$data <- renderText({
    paste(capture.output(str(input$file)), collapse = "\n")
  })
}

if (interactive()) shiny::shinyApp(ui, server)
}
\seealso{
\code{\link[shiny:fileInput]{shiny::fileInput()}}
}
