% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twTextAreaInput.R
\name{twTextAreaInput}
\alias{twTextAreaInput}
\title{Wrapper around \code{\link[shiny:textAreaInput]{shiny::textAreaInput()}} but allowing for more classes}
\usage{
twTextAreaInput(
  inputId,
  label,
  value = "",
  placeholder = NULL,
  width = NULL,
  height = NULL,
  rows = NULL,
  cols = NULL,
  resize = NULL,
  container_class = NULL,
  label_class = NULL,
  input_class = NULL,
  label_after_input = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{height}{The height of the input, e.g. \code{'400px'}, or \code{'100\%'}; see
\code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{rows}{The value of the visible character rows of the input, e.g. \code{6}.
If the \code{height} argument is specified, \code{height} will take precedence in the
browser's rendering.}

\item{cols}{Value of the visible character columns of the input, e.g. \code{80}.
This argument will only take effect if there is not a CSS \code{width} rule
defined for this element; such a rule could come from the \code{width} argument
of this function or from a containing page layout such as
\code{\link[shiny:fluidPage]{fluidPage()}}.}

\item{resize}{Which directions the textarea box can be resized. Can be one of
\code{"both"}, \code{"none"}, \code{"vertical"}, and \code{"horizontal"}. The default, \code{NULL},
will use the client browser's default setting for resizing textareas.}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{input_class}{additional classes to be applied to the input element}

\item{label_after_input}{TRUE/FALSE if the label should be put after the
input box. Default is FALSE. Useful for special cases (floating labels),
c.f. 04-shiny-inputs example app.}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:textAreaInput]{shiny::textAreaInput()}} but allowing for more classes
}
\examples{
shiny::textAreaInput("id", "Label",
  value = "The value", width = "200px",
  placeholder = "Placeholder"
)
twTextAreaInput("id", "Label",
  value = "The value", width = "200px",
  height = "200px", placeholder = "Placeholder",
  container_class = "CONTAINER", label_class = "LABEL", input_class = "INPUT"
)

# basic full shiny example
library(shiny)

ui <- fluidPage(
  use_tailwind(),
  twTextAreaInput(
    "text", "A Text",
    placeholder = "Here goes a placeholder",
    width = "400px", height = "400px",
    # Apply tailwind classes
    container_class = "w-48 m-4 p-2 border border-gray-200 rounded-md drop-shadow-md",
    label_class = "font-serif text-gray-600",
    input_class = "drop-shadow-lg font-mono text-gray-600 rounded-md border-amber-400"
  ),
  verbatimTextOutput("value")
)

server <- function(input, output) {
  output$value <- renderText(input$text)
}

if (interactive()) shiny::shinyApp(ui_basic, server)
}
\seealso{
\code{\link[shiny:textAreaInput]{shiny::textAreaInput()}}
}
