% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/govLayouts.R
\name{layouts}
\alias{layouts}
\alias{gov_main_layout}
\alias{gov_row}
\alias{gov_box}
\alias{gov_text}
\title{Page Layout Functions}
\usage{
gov_main_layout(..., inputID = "main")

gov_row(...)

gov_box(..., size = "full")

gov_text(...)
}
\arguments{
\item{...}{include the components of the UI that you want within the
main page.  These components are made to flow through each other.  See
example}

\item{inputID}{ID of the main div.  Defaults to "main"}

\item{size}{size of the box in the row.  Optional are full, one-half,
two-thirds, one-third and one-quarter.  Defaults to "full"}
}
\value{
a html shiny layout div
}
\description{
These function loads the page layout in a gov layout.  There is a selection
of components that can sit within each other.  The gov_main_layout is the
overarching layout.  The gov_row creates a each row and gov_box creates
a box within the row.  The gov_text is a container for text bodies.
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::gov_main_layout(
      shinyGovstyle::gov_row(
        shinyGovstyle::gov_box(
          size = "full",
          shinyGovstyle::gov_text("govuk-grid-column-full")
        )
      ),
      shinyGovstyle::gov_row(
        shinyGovstyle::gov_box(
          size = "one-half",
          shinyGovstyle::gov_text("govuk-grid-column-one-half")
        ),
        shinyGovstyle::gov_box(
          size = "one-half",
          shinyGovstyle::gov_text("govuk-grid-column-one-half")
        )
      ),
      shinyGovstyle::gov_row(
        shinyGovstyle::gov_box(
          size = "one-third",
          shinyGovstyle::gov_text("govuk-grid-column-one-third")
        ),
        shinyGovstyle::gov_box(
          size = "two-third",
          shinyGovstyle::gov_text("govuk-grid-column-two-third")
        )
      ),
      shinyGovstyle::gov_row(
        shinyGovstyle::gov_box(
          size = "one-quarter",
          shinyGovstyle::gov_text("govuk-grid-column-one-quarter")
        ),
        shinyGovstyle::gov_box(
          size = "three-quarters",
          shinyGovstyle::gov_text("govuk-grid-column-three-quarters")
        )
      )
    ),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {}
  shinyApp(ui = ui, server = server)
}
}
\keyword{style}
