% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_aggregator.R
\docType{class}
\name{null_aggregator}
\alias{null_aggregator}
\title{NULL aggregator.}
\format{
An \code{R6::R6Class} object
}
\description{
It does not aggregate the data but returns the full samples within the range.
}
\examples{
data(noise_fluct)
agg <- null_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500)
plotly::plot_ly(
  x = d_agg$x[1:100], y = d_agg$y[1:100], type = "scatter", mode = "lines"
)
}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{null_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-null_aggregator-new}{\code{null_aggregator$new()}}
\item \href{#method-null_aggregator-aggregate}{\code{null_aggregator$aggregate()}}
\item \href{#method-null_aggregator-clone}{\code{null_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-null_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-null_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{null_aggregator$new(..., interleave_gaps, coef_gap, NA_position)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-null_aggregator-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-null_aggregator-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
A function that does nothing other than inserting NAs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{null_aggregator$aggregate(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed to \code{super$aggregate}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-null_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-null_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{null_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
