% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_flextables.R
\name{get_flextable}
\alias{get_flextable}
\title{get_flextable}
\usage{
get_flextable(
  sbm,
  labels = "default",
  type = c("blockProp", "connectParam", "storedModels"),
  settings = list()
)
}
\arguments{
\item{sbm}{an sbm model product of \pkg{sbm} estimation (simple or bipartite)}

\item{labels}{labels for nodes.
If it's simple sbm it should be a single character ("default" -> c("nodes")).
If sbm is bipartite a named character (names are row and col) ("default" -> c(row = 'row', col = 'col')).}

\item{type}{the type of table wanted.}

\item{settings}{a list of settings}
}
\value{
Return the selected flextable
}
\description{
A fct that build a flextable from an sbm object
}
\details{
Values of \code{type}
\describe{
 \item{'blockProp': }{gives the block proportions.}
 \item{'connectParam': }{gives the block connectivity.}
 \item{'storedModels': }{gives the stored modems summary.}
}

The list of parameters \code{settings} for the flextable

\describe{
 \item{"caption": }{Caption is the flextable title (character)}
 \item{"digits": }{nb of digits wanted to be shown in the table}
 \item{"selected_col": }{Color highlighting the selected model}
 \item{"best_col": }{Color of text for the best model}
}
}
\examples{

# my_sbm <- sbm::estimateBipartiteSBM(sbm::fungusTreeNetwork$fungus_tree,
#                                     model = 'bernoulli')
my_sbm <- FungusTreeNetwork$sbmResults$fungus_tree

get_flextable(my_sbm,
  labels = c(row = "Fungus", col = "Trees"),
  type = "blockProp"
)

get_flextable(my_sbm,
  labels = c(row = "Fungus", col = "Trees"),
  type = "connectParam", settings = list(digits = 5)
)

get_flextable(my_sbm,
  labels = "default",
  type = "storedModels", settings = list(caption = "New Title")
)

}
