% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-time.R
\name{timeInput}
\alias{timeInput}
\title{Create a time input}
\usage{
timeInput(inputId, label, value = NULL, seconds = TRUE, minute.steps = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{The desired time value. Must be a instance of \code{\link{DateTimeClasses}}.}

\item{seconds}{Show input for seconds. Defaults to TRUE.}

\item{minute.steps}{Round time to multiples of \code{minute.steps} (should be a whole number).
If not NULL sets \code{seconds} to \code{FALSE}.}
}
\value{
Returns a \code{POSIXlt} object, which can be converted to
a \code{POSIXct} object with \code{as.POSIXct} for more efficient storage.
}
\description{
Creates a time widget that consists of separate numeric inputs for the hours, minutes, and
seconds. The input and output values of the time widget are instances of
\code{\link{DateTimeClasses}}, these can be converted to and from character strings with
\code{\link{strptime}} and \code{\link{strftime}}.
Additionally, the input can be specified as a character string in the `hh:mm:ss` format or an
\code{\link[hms]{hms}} class. For a simple example app see \code{\link{shinyTimeExample}}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  # Default value is 00:00:00
  timeInput("time1", "Time:"),

  # Set to current time
  timeInput("time2", "Time:", value = Sys.time()),

  # Set to custom time
  timeInput("time3", "Time:", value = strptime("12:34:56", "\%T")),

  # Set to custom time using hms
  timeInput("time4", "Time:", value = hms::as_hms("23:45:07")),

  # Set to custom time using character string
  timeInput("time5", "Time:", value = "21:32:43"),

  # Use hh:mm format
  timeInput("time6", "Time:", seconds = FALSE),

  # Use multiples of 5 minutes
  timeInput("time7", "Time:", minute.steps = 5)
)

shinyApp(ui, server = function(input, output) { })
}

}
\seealso{
\code{\link{strptime}}, \code{\link{strftime}}, \code{\link{DateTimeClasses}}

Other shinyTime functions: 
\code{\link{shinyTimeExample}()},
\code{\link{updateTimeInput}()}
}
\concept{shinyTime functions}
