% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{is_device_desktop}
\alias{is_device_desktop}
\title{Is the user on a desktop device?}
\usage{
is_device_desktop()
}
\value{
Whether or not this user is on desktop
}
\description{
Convenience function that checks if the user's device is detected as desktop.
See \code{\link[=get_device]{get_device()}} for details.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Are you on desktop?",
    textOutput("result")
  )
  server <- function(input, output, session) {
    output$result <- renderText({
      shinybrowser::is_device_desktop()
    })
  }
  shinyApp(ui, server)
}
}
