% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-button.R
\name{material_button}
\alias{material_button}
\title{Create a shinymaterial button}
\usage{
material_button(input_id, label, icon = NULL, depth = NULL, color = NULL)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The button text.}

\item{icon}{String. The name of the icon. Leave empty for no icon. Visit \url{https://materializecss.com/icons.html} for a list of available icons.}

\item{depth}{Integer. The amount of depth of the button. The value should be between 0 and 5. Leave empty for the default depth.}

\item{color}{String. The color of the button. Leave empty for the default color. Visit \url{https://materializecss.com/color.html} for a list of available colors.}
}
\description{
Build a shinymaterial button. The initial value is zero, and increases by one on each press.
}
\examples{
material_button(
  input_id = "example_button",
  label = "Button",
  icon = "cloud",
  depth = 5,
  color = "blue lighten-2"
)
}
\seealso{
\code{\link{update_material_button}}
}
