% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-text-box.R
\name{material_text_box}
\alias{material_text_box}
\title{Create a shinymaterial text box}
\usage{
material_text_box(input_id, label, value = "", color = NULL, icon = NULL)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The text box label.}

\item{value}{String. Initial value.}

\item{color}{String. The accent color of the text box. Leave empty for the default color. Visit \url{https://materializecss.com/color.html} for a list of available colors. \emph{This input requires using color hex codes, rather than the word form. E.g., "#ef5350", rather than "red lighten-1".}}

\item{icon}{String. The name of the icon. Leave empty for no icon. Visit \url{https://materializecss.com/icons.html} for a list of available icons.}
}
\description{
Build a shinymaterial text box.
}
\examples{
material_text_box(
  input_id = "example_text_box",
  label = "text box",
  icon = "search",
  color = "#ef5350"
)
}
\seealso{
\code{\link{update_material_text_box}}
}
