% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_report.R
\name{delete_report}
\alias{delete_report}
\title{Deletes a report from the database}
\usage{
delete_report(reportName, shinyMgrPath, fileDelete = FALSE)
}
\arguments{
\item{reportName}{The name of the report to be deleted, character string.}

\item{shinyMgrPath}{The path to the shinymgr project. Typically the 
working directory.}

\item{fileDelete}{TRUE/FALSE, whether the report .Rmd file should also 
be deleted - defaults to FALSE.}
}
\value{
An integer value with the total number of rows deleted 
(including cascades)
}
\description{
Deletes a report (and associated file if requested) from 
the shinymgr.sqlite database
}
\section{More Info}{

The delete_report() function is described in the "reports" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other delete: 
\code{\link{delete_app}()},
\code{\link{delete_mod}()}
}
\concept{delete}
