% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_register.R
\name{mod_register}
\alias{mod_register}
\title{Register (inserts) a new module into the shinymgr project}
\usage{
mod_register(modName, shinyMgrPath)
}
\arguments{
\item{modName}{Name of the new module}

\item{shinyMgrPath}{Directory that holds the main shinymgr project}
}
\value{
Nothing.  Records are inserted into shinymgr.sqlite.
}
\description{
Insert a new record into the shinymgr.sqlite database table
"modules" and accompanying tables ("modFunctionArguments", 
"modFunctionReturns", "modPackages")
}
\details{
This function reads in a module file created by 
\code{\link{mod_init}}
and parses the header using \code{\link{mod_header_parser}} to populate the 
modules, modFunctionArguments, modFunctionReturns, and modPackages tables of
the
shinymgr.sqlite  database. These tables are referenced in the app builder, 
so module headers must match the module functions exactly.
}
\section{More Info}{

The mod_register() function is described in the "shinymgr_modules" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
\code{\link{mod_init}}

Other module: 
\code{\link{check_mod_info}()},
\code{\link{mod_header_parser}()},
\code{\link{mod_init}()}
}
\concept{module}
