% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qry_row.R
\name{qry_row}
\alias{qry_row}
\title{Retrieve one or more rows from a specified table from the 
shinymgr.sqlite. Used internally.
database given a set of conditions on one or more columns.}
\usage{
qry_row(tableName, rowConditions, colConditions, shinyMgrPath)
}
\arguments{
\item{tableName}{The name of the table of the shinymgr database (e.g. 
people, apps, etc.).}

\item{rowConditions}{A dataframe where the keys correspond to columns of the
specified dataframe and key values correspond to the equality condition that
must be satisfied by any returning rows, else returns all rows (default 
returns all rows).}

\item{colConditions}{A vector specifying the names of columns to be returned 
from the query (default returns all columns).}

\item{shinyMgrPath}{File path to the main shiny manager project directory}
}
\value{
Dataframe consisting of the specified rows and columns
}
\description{
Returns dataframe containing specified columns and rows from the
shinymgr database based on specified conditions.
}
\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{
# set the file path to the main shinymgr directory
parentPath <- tempdir()
shinyMgrPath <- paste0(parentPath, '/shinymgr')

shinymgr_setup(parentPath = parentPath, demo = TRUE)

# use the default database path
qry_row(
  tableName = 'apps', 
  rowConditions = data.frame(pkAppName = 'iris_explorer'), 
  colConditions = c('appDisplayName', 'appDescription'),
  shinyMgrPath = shinyMgrPath
)

# remove demo
unlink(shinyMgrPath, recursive = TRUE)

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other qry: 
\code{\link{qry_app_flow}()},
\code{\link{qry_app_stitching}()},
\code{\link{qry_insert}()},
\code{\link{qry_mod_info}()}
}
\concept{qry}
