% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_db_populate.R
\name{shiny_db_populate}
\alias{shiny_db_populate}
\title{Populates an empty shinymgr.sqlite database with demo data}
\usage{
shiny_db_populate(conx)
}
\arguments{
\item{conx}{A connection to the shinymgr.sqlite database}
}
\value{
Returns invisible, but the shinymgr.sqlite database will be 
populated.
}
\description{
Populates empty shinymgr.sqlite database
with demo data. The learnr tutorials illustrate the shinymgr 
approach and utilize the demo data.  This function is
typically not called; instead use \code{\link{shinymgr_setup}}
}
\details{
The shinymgr database is a SQLite database.  The function uses
the R package, RSQLite, to connect the database with R (the package
itself contains SQLite, so no external software is needed.  Once the
connection is made, the function uses database functions
from the package, DBI, which in turn can be used to query the database,
add records, etc.) This function is not intended to be used. 
Rather, users should use \code{\link{shinymgr_setup}} to copy the
database  instance that comes with the package.  The function is
included here so users can inspect the code used to create the database.
}
\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{

# ------------------------------------------------------------
# Set up an empty database for demonstration and then delete it
# ------------------------------------------------------------

# Create the database (to be deleted):
db_dir <- tempdir()
db_path <- paste0(db_dir, "/shinymgr.sqlite")
shiny_db_create(db_path = db_path)


# Verify that the database exists in your current working directory
file.exists(db_path)

# function will populate an empty sqlite database with the RData files 
# in the package's data folder
conx <- DBI::dbConnect(drv = RSQLite::SQLite(), dbname = db_path)
shiny_db_populate(conx)

# look at some tables with R coding
DBI::dbReadTable(conx, "apps")
DBI::dbReadTable(conx, "modules")

# disconnect from database
DBI::dbDisconnect(conx)

# Remove demo database
unlink(db_path)

}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other database: 
\code{\link{shiny_db_create}()}
}
\concept{database}
