% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{MRPWorkflow-method-link_acs}
\alias{MRPWorkflow-method-link_acs}
\alias{link_acs}
\title{Link sample data to ACS data}
\usage{
link_acs(link_geo = NULL, acs_year = 2023)
}
\arguments{
\item{link_geo}{Character string specifying the geographic level for linking. Options are \code{"zip"}, \code{"county"}, and \code{"state"}.}

\item{acs_year}{Numeric value specifying the last year of the data collection period for the target ACS dataset.}
}
\value{
No return value, called for side effects.
}
\description{
The \verb{$link_acs()} method obtains poststratification data by
linking the preprocessed sample data to the American Community Survey
based on given geographic granularity and year. See the
\href{https://mrp-interface.github.io/shinymrp/articles/data-prep}{More on data preparation}
vignette for more information on data linking. For usage examples, refer to the
\href{https://mrp-interface.github.io/shinymrp/articles/example#link_acs}{More examples of R6 classes}
vignette.
}
